
namespace CHTLand.SDK.Module
{
    using Multiple;
    using Input;
    using DigitalAsset;
    using User;
    using Component;
    using Player;
    using Storage;
    using Network;

    /// <summary>
    /// 提供創作者存取CHTLand模組
    /// </summary> <summary>
    /// 
    /// </summary>
    public static class CHTLandProxy
    {
        /// <summary>
        /// 提供多人連線配對功能
        /// </summary>
        public static IMultiConnectManager multiConnectManager;

        /// <summary>
        /// 提供多人連線數值控制功能
        /// </summary>
        public static IMultiActManager multiActManager;

        /// <summary>
        /// 提供Camera控制與覆寫功能
        /// </summary>
        public static ICameraManager cameraManager;

        /// <summary>
        /// 提供本地麥克風控制與覆寫功能
        /// </summary>
        public static IMicManager micManager;

        /// <summary>
        /// 提供控制2D GUI功能
        /// </summary>
        public static IGUIManager guiManager;

        /// <summary>
        /// 任務相關功能
        /// </summary>
        public static IMissionManager missionManager;
        /// <summary>
        /// 開啟檔案相關功能
        /// </summary>
        public static IFileManager fileManager;

        /// <summary>
        /// 提供NFT錢包查詢與資產移轉功能
        /// </summary>
        public static IDigitalAssetManager digitalAssetManager;

        /// <summary>
        /// 提供本地使用者資料
        /// </summary>
        public static IUserManager userManager;

        /// <summary>
        /// 提供互動元件使用
        /// </summary>
        public static IComponentManager componentManager;

        /// <summary>
        /// 提供Player控制功能
        /// </summary>
        public static IPlayerManager playerManager;

        /// <summary>
        /// 提供場景Storage
        /// </summary>
        public static ISceneStorageManager sceneStorageManager;

        /// <summary>
        /// 提供網路通訊功能
        /// </summary>
        public static INetworkRequestManager networkRequestManager;
    }

}