using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if UNITY_EDITOR
using UnityEditor;
#endif

namespace CHTLand.SDK.Module.Component{
    /// <summary>
    /// 寶箱元件
    /// </summary> 
    [ExecuteInEditMode]
    public class ChtChestComponent : ChtBaseComponent
    {
        [SerializeField] 
        private string chestComponentID;
        public string ChestComponentID => chestComponentID;
        
        //Type of component
        [HideInInspector]
        ComponentType type = ComponentType.ChtChestComponent;
        protected override void Awake()
        {
            base.Awake();
            //Debug.LogWarning($"Chest Component ID : {ObjectID}");
        }
        void Start()
        {
            if (Application.isPlaying && CHTLandProxy.componentManager != null)
            {
                CHTLandProxy.componentManager.InitChestComponent(this); 
            }
            Debug.Log(type.ToString());
        }
        
        #if UNITY_EDITOR
        
        private string myChestModel = "Editor/Design/Model/chest.fbx";
        private string myCoinPileModel = "Editor/Design/Model/coinPile.fbx";
        private string myDetectBoxPath = "Editor/Design/Prefab/DetectBox.prefab";
        private Vector3 myColliderSize = new Vector3(0.6f, 0.77f, 0.955f);
        private Vector3 myColliderCenter = new Vector3(0.0f, 0.35f, 0.0f);
        private Vector3 myIconPosition;
        private GameObject myDetectBox;
        
        protected override void OnValidate()
        {
            base.OnValidate();
            if (!Application.isPlaying)
            {
                // 同步 base 的 objectID 給 seatComponentID
                chestComponentID = objectID;
                UnityEditor.EditorUtility.SetDirty(this); // 確保 Inspector 顯示更新
            }
        }
        void OnEnable()
        {
            EditorApplication.update += OnEditorUpdate;
        }

        void OnDisable()
        {
            EditorApplication.update -= OnEditorUpdate;
        }

        void OnEditorUpdate()
        {
            // 如果正在Play或準備Play，就不要做任何事
            if (EditorApplication.isPlayingOrWillChangePlaymode)
            {
                return;
            }
            LockScale();
            
            //設定DetctBox大小位置
            Transform mydetectBoxTransform = transform.Find("DetectBox");
            if (mydetectBoxTransform == null)
            {
                FindPrefab(myDetectBoxPath);
                myDetectBox = transform.Find("DetectBox").gameObject;
                myDetectBox.transform.parent = transform;
                myDetectBox.transform.localPosition = myColliderCenter;
                myDetectBox.transform.localRotation = transform.rotation;
                myDetectBox.transform.localScale = myColliderSize;
            }

            Transform chestTransform = transform.Find("chest");
            Transform coinPileTransform = transform.Find("coinPile");
            //創建模型
            if (chestTransform == null)
            {
                FindPrefab(myChestModel);
                
            }
            
            //創建模型
            if (coinPileTransform == null)
            {
                FindPrefab(myCoinPileModel);
                
            }

            if (coinPileTransform != null && chestTransform != null && mydetectBoxTransform != null)
            {
                CreateCollider();
                BoxCollider myCollider = gameObject.GetComponent<BoxCollider>();
                myCollider.size = myColliderSize;
                myCollider.center = myColliderCenter;
                //讓boxCollider在inpector不顯示
                myCollider.hideFlags = HideFlags.HideInInspector;
                
                DetectCollisions(default, default, myColliderSize, mydetectBoxTransform.position, "DetectBox");

                //鎖定Prefab
                InheritLockAllComponents(mydetectBoxTransform.gameObject);
                InheritLockAllComponents(chestTransform.gameObject);
                InheritLockAllComponents(coinPileTransform.gameObject);
            }
            else
            {
                Debug.Log("Not find chest, coinPile or detectBox!");
            }

      
        }
        
        string myIconPath = "Editor/Design/Icon/treasure.png";
        void OnDrawGizmos()
        {
            Vector3 myPosition = transform.position;
            
            //icon離軸偏移的距離
            float myOffset = 0.5f;
            myIconPosition = new Vector3(myPosition.x - myOffset, myPosition.y + myOffset , myPosition.z);
            IconPathToPackage(myIconPath, myIconPosition);
        }
        
        #endif
        
    }

}