using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if UNITY_EDITOR
using UnityEditor;
#endif

namespace CHTLand.SDK.Module.Component
{
    /// <summary>
    /// 對話元件
    /// </summary>
    [ExecuteInEditMode]
    public class ChtDialogComponentOnlyConversation : ChtBaseComponent
    {
        [SerializeField] 
        private string dialogOnlyComponentID;
        public string DialogOnlyComponentID => dialogOnlyComponentID;

        //Type of component
        [HideInInspector]
        ComponentType type = ComponentType.ChtDialogComponentOnlyConversation;
        protected override void Awake()
        {
            base.Awake();
            //Debug.LogWarning($"Chest Component ID : {ObjectID}");
        }
        void Start()
        {
            if (Application.isPlaying && CHTLandProxy.componentManager != null)
            {
                CHTLandProxy.componentManager.InitDialogComponentOnlyConversation(this); 
            }
            Debug.Log(type.ToString());
        }
        
        #if UNITY_EDITOR
        private string myDetectBoxPath = "Editor/Design/Prefab/DetectBox.prefab";
        private string myDialog = "Editor/Design/Prefab/Dialog.prefab";
        private Vector3 myColliderBoxSize = new Vector3(0.25f, 0.25f, 0.25f);
        
        protected override void OnValidate()
        {
            base.OnValidate();
            if (!Application.isPlaying)
            {
                // 同步 base 的 objectID 給 seatComponentID
                dialogOnlyComponentID = objectID;
                UnityEditor.EditorUtility.SetDirty(this); // 確保 Inspector 顯示更新
            }
        }

        void OnEnable()
        {
            EditorApplication.update += OnEditorUpdate;
        }

        void OnDisable()
        {
            EditorApplication.update -= OnEditorUpdate;
        }

        void OnEditorUpdate()
        {
            // 如果正在Play或準備Play，就不要做任何事
            if (EditorApplication.isPlayingOrWillChangePlaymode)
            {
                return;
            }
            Transform detectBoxTransform = transform.Find("DetectBox");
            if (detectBoxTransform == null)
            {
                FindPrefab(myDetectBoxPath);
                detectBoxTransform = transform.Find("DetectBox");
                detectBoxTransform.position = transform.position;
                detectBoxTransform.transform.localScale = myColliderBoxSize;
                detectBoxTransform.GetComponent<BoxCollider>().enabled = true;
            }
            
            Transform dialogTransform = transform.Find("Dialog");
            if (dialogTransform == null)
            {
                FindPrefab(myDialog);
            } 

            if (dialogTransform != null && detectBoxTransform != null)
            {
                DetectCollisions(default, default, myColliderBoxSize, default, "DetectBox");
                InheritLockAllComponents(detectBoxTransform.gameObject);
                InheritLockAllComponents(dialogTransform.gameObject);
            } 
        }

        #endif

    }
}