using System.Collections;
using System.Collections.Generic;
using UnityEngine;
#if UNITY_EDITOR
using UnityEditor;
#endif

namespace CHTLand.SDK.Module.Component
{
    /// <summary>
    /// 生成點元件
    /// </summary>
    [ExecuteInEditMode]
    public class ChtEntryComponent : ChtBaseComponent
    {
        [SerializeField] 
        private string entryComponentID;
        public string EntryComponentID => entryComponentID;

        //Type of component
        [HideInInspector]
        ComponentType type = ComponentType.ChtEntryComponent;
        private static ChtEntryComponent entryComponentInstance;
        private bool delete = false;
       
        void Start()
        {
            if (Application.isPlaying && CHTLandProxy.componentManager != null)
            {
                CHTLandProxy.componentManager.InitEntryComponent(this); 
            }
            Debug.Log(type.ToString());
        }
        
        protected override void Awake()
        {
            base.Awake();
            entryComponentID = objectID;
            //Debug.LogWarning($"Chest Component ID : {ObjectID}");
        

            if (entryComponentInstance == null)
            {
                entryComponentInstance = this;
            }
            else
            {
                delete = true;
#if UNITY_EDITOR
                if (!Application.isPlaying)
                {
                    EditorApplication.delayCall+= ()=>
                    {
                        //當chtEntryComponent多於1個，刪除其他的實例。
                        if(this != null)
                        {
                            DestroyImmediate(gameObject);
                            Debug.LogWarning("ChtEntryComponent instance already exists.");
                        }
                        else
                        {
                            Debug.LogWarning("ChtEntryComponent instance already exists.");
                        }
                    };
                }
            }
        }
        
        private string myEntryPrefabPath = "Editor/Design/Prefab/ChtEntryComp.prefab";
        private string myIconBackPath = "Editor/Design/Prefab/Back.prefab";
        private Vector3 myColliderBoxSize;
        void OnEnable()
        {
            if(delete == true)
            {
                EditorApplication.update -= OnEditorUpdate;
            }
            else
            {
                EditorApplication.update += OnEditorUpdate;
            }
            
        }

        void OnDisable()
        {
            EditorApplication.update -= OnEditorUpdate;
        }

        void OnEditorUpdate()
        {
            // 如果正在Play或準備Play，就不要做任何事
            if (EditorApplication.isPlayingOrWillChangePlaymode)
            {
                return;
            }
            LockScaleSame();
            
            Transform entryTransform = transform.Find("ChtEntryComp");
            if (entryTransform == null)
            {
                FindPrefab(myEntryPrefabPath);
            }

            Transform myIconBackTransform = transform.Find("Back");
            if (myIconBackTransform == null)
            {
                FindPrefab(myIconBackPath);
                myIconBackTransform = transform.Find("Back");
                myIconBackTransform.Rotate(Vector3.right, -90.0f);
            }

            if (entryTransform != null && myIconBackTransform != null)
            {
                myColliderBoxSize = entryTransform.localScale;
                DetectCollisions(default, default, myColliderBoxSize, default, "ChtEntryComp");
                
                InheritLockAllComponents(entryTransform.gameObject);
                InheritLockAllComponents(myIconBackTransform.gameObject);
            }
        }
#else
        }
    }
#endif
    }
}