using System.Collections;
using System.Collections.Generic;
using UnityEngine;
#if UNITY_EDITOR
using UnityEditor;
#endif

namespace CHTLand.SDK.Module.Component{
    /// <summary>
    /// 抽獎元件
    /// </summary> 
    [ExecuteInEditMode]
    public class ChtLotteryComponent : ChtBaseComponent
    {
        [SerializeField] 
        private string lotteryComponentID;
        public string LotteryComponentID => lotteryComponentID;
        
        //Type of component
        [HideInInspector]
        ComponentType type = ComponentType.ChtLotteryComponent;
        protected override void Awake()
        {
            base.Awake();
            //Debug.LogWarning($"Chest Component ID : {ObjectID}");
        }
        void Start()
        {
            if (Application.isPlaying && CHTLandProxy.componentManager != null)
            {
                CHTLandProxy.componentManager.InitLotteryComponent(this); 
            }
            Debug.Log(type.ToString());
        }
        
        #if UNITY_EDITOR
        
        private string myLotteryModel = "Editor/Design/Prefab/lottery.prefab";
        private string myDetectBoxPath = "Editor/Design/Prefab/DetectBox.prefab";
        private Vector3 myColliderSize = new Vector3(1.135f, 2.7f, 2.97f);
        private Vector3 myColliderCenter = new Vector3(0.13f, 1.35f, 0.0f);
        private Vector3 myUpIconPosition = new Vector3(0.0f, 2.71f, 0.0f);
        private Quaternion myUpIconRotation = Quaternion.Euler(90.0f, 0.0f, -90.0f);
        private Vector3 myFrontIconPosition = new Vector3(-0.5f, 1.35f, 0.0f);
        private Quaternion myFrontIconRotation = Quaternion.Euler(0.0f, 90.0f, 0.0f);
        private Vector3 myIconPosition;
        private GameObject myDetectBox;
        protected override void OnValidate()
        {
            base.OnValidate();
            if (!Application.isPlaying)
            {
                // 同步 base 的 objectID 給 seatComponentID
                lotteryComponentID = objectID;
                UnityEditor.EditorUtility.SetDirty(this); // 確保 Inspector 顯示更新
            }
        }
        
        void OnEnable()
        {
            EditorApplication.update += OnEditorUpdate;
        }

        void OnDisable()
        {
            EditorApplication.update -= OnEditorUpdate;
        }

        void OnEditorUpdate()
        {
            // 如果正在Play或準備Play，就不要做任何事
            if (EditorApplication.isPlayingOrWillChangePlaymode)
            {
                return;
            }
            LockScale();
            
            //設定DetctBox大小位置
            Transform mydetectBoxTransform = transform.Find("DetectBox");
            if (mydetectBoxTransform == null)
            {
                FindPrefab(myDetectBoxPath);
                myDetectBox = transform.Find("DetectBox").gameObject;
                myDetectBox.transform.parent = transform;
                myDetectBox.transform.localPosition = myColliderCenter;
                myDetectBox.transform.localRotation = transform.rotation;
                myDetectBox.transform.localScale = myColliderSize;

                
            }

            //創建模型
            Transform myLotteryTransform = transform.Find("lottery");
            if (transform.Find("lottery") == null)
            {
                FindPrefab(myLotteryModel);
                
            }
            
            Transform iconFront = transform.Find("Front");
            Transform iconUp = transform.Find("Up");
            
            //找Up Front的Prefab
            if (iconFront == null)
            {
                FindPrefab("Editor/Design/Prefab/Front.prefab");
                iconFront = transform.Find("Front");
                iconFront.parent = this.transform;
                iconFront.localPosition = myFrontIconPosition;
                iconFront.localRotation = myFrontIconRotation;
                InheritLockAllComponents(iconFront.gameObject);
            }
            if (iconUp == null)
            {
                FindPrefab("Editor/Design/Prefab/Up.prefab");
                iconUp = transform.Find("Up");
                iconUp.parent = this.transform;
                iconUp.localPosition = myUpIconPosition;
                iconUp.localRotation = myUpIconRotation;
                InheritLockAllComponents(iconUp.gameObject);
            }
            
            if (transform.Find("lottery") != null && transform.Find("DetectBox") != null && mydetectBoxTransform != null)
            {
                CreateCollider();
                BoxCollider myCollider = gameObject.GetComponent<BoxCollider>();
                myCollider.size = myColliderSize;
                myCollider.center = myColliderCenter;
                
                //讓boxCollider在inpector不顯示
                myCollider.hideFlags = HideFlags.HideInInspector;

                DetectCollisions(default, default, myColliderSize, mydetectBoxTransform.position, "DetectBox");

                //鎖定Prefab
                InheritLockAllComponents(mydetectBoxTransform.gameObject);
                InheritLockAllComponents(myLotteryTransform.gameObject);
            }
            else
            {
                Debug.Log("Not find lottery or DetectBox!");
            }
        }
        
        string myIconPath = "Editor/Design/Icon/gatcha.png";
        void OnDrawGizmos()
        {
            Vector3 myPosition = transform.position;
            Vector3 myScale = transform.localScale;
            
            //icon離軸偏移的距離
            float myOffset = 0.3f;
            float myOffsetY = 1.35f;

            myIconPosition = new Vector3(myPosition.x + (-myScale.x / 2) -myOffset, myPosition.y + myOffsetY, myPosition.z);
            IconPathToPackage(myIconPath, myIconPosition);
        }
        
        #endif
        
    }
}