using UnityEngine;
using System;

#if UNITY_EDITOR
using UnityEditor;
#endif

namespace CHTLand.SDK.Module.Component
{
    /// <summary>
    /// 模型元件
    /// </summary>
    [ExecuteInEditMode]
    public class ChtModelComponent : ChtBaseComponent
    {
        [SerializeField] 
        private string modelComponentID;
        public string ModelComponentID => modelComponentID;
    
        //Type of component
        [HideInInspector]
        ComponentType type = ComponentType.ChtModelComponent;
        protected override void Awake()
        {
            base.Awake();
            //Debug.LogWarning($"Chest Component ID : {ObjectID}");
        }
        void Start()
        {

            if (Application.isPlaying && CHTLandProxy.componentManager != null)
            {
                CHTLandProxy.componentManager.InitModelComp(this);
            }
            Debug.Log(type.ToString());
        }

#if UNITY_EDITOR


        private Vector3 myUpIconPosition = new Vector3(0.0f, 0.51f, 0.0f);
        private Vector3 myFrontIconPosition = new Vector3(0.0f, 0.0f, -0.51f);
        private bool isDrawFarGizmos = false;
        
        protected override void OnValidate()
        {
            base.OnValidate();
            if (!Application.isPlaying)
            {
                // 同步 base 的 objectID 給 seatComponentID
                modelComponentID = objectID;
                UnityEditor.EditorUtility.SetDirty(this); // 確保 Inspector 顯示更新
            }
        }

        void OnEnable()
        {
            EditorApplication.update += OnEditorUpdate;
        }

        void OnDisable()
        {
            EditorApplication.update -= OnEditorUpdate;
        }

        void OnEditorUpdate()
        {
            // 如果正在Play或準備Play，就不要做任何事
            if (EditorApplication.isPlayingOrWillChangePlaymode)
            {
                return;
            }
            //鎖定模型的比例
            LockScale();

            meshFilter = gameObject.GetComponent<MeshFilter>();
            meshRenderer = gameObject.GetComponent<MeshRenderer>();
            if (meshFilter == null)
            {
                CreateMeshFilter("Cube");
                if (meshRenderer == null)
                {
                    CreateRenderer();
                }
            }
            
            if (meshFilter != null && meshRenderer != null)
            {
                meshFilter.hideFlags = HideFlags.NotEditable;
                meshRenderer.hideFlags = HideFlags.NotEditable;
            }

            CreateCollider();

            if (meshFilter != null && meshRenderer != null)
            {
                DetectCollisions();
            }

            Transform iconFront = transform.Find("Front");
            Transform iconUp = transform.Find("Up");
            //找Up Front的Prefab
            if (iconFront == null)
            {
                FindPrefab("Editor/Design/Prefab/Front.prefab");
                iconFront = transform.Find("Front");
                iconFront.parent = this.transform;
                iconFront.localPosition = myFrontIconPosition;
                InheritLockAllComponents(iconFront.gameObject);
            }

            if (iconUp == null)
            {
                FindPrefab("Editor/Design/Prefab/Up.prefab");
                iconUp = transform.Find("Up");
                iconUp.parent = this.transform;
                iconUp.localPosition = myUpIconPosition;
                InheritLockAllComponents(iconUp.gameObject);
            }

            //計算物件與視角Camera的距離
            CameraToSceneView();
            Transform front = transform.Find("Front");
            Transform up = transform.Find("Up");
            //Debug.Log(toDistance.ToString());

            if (toDistance >= closeDistance)
            {
                front.gameObject.SetActive(false);
                up.gameObject.SetActive(false);
                isDrawFarGizmos = true;
            }
            else if (toDistance <= closeDistance)
            {
                front.gameObject.SetActive(true);
                up.gameObject.SetActive(true);
                isDrawFarGizmos = false;
            }
        }

        string modelIconPath = "Editor/Design/Icon/model.png";
        void OnDrawGizmos()
        {
            DrawCubeIcon();
            if (isDrawFarGizmos == true)
            {
                IconPathToPackage(modelIconPath, transform.position);
            }
        }

#endif
    }
}




