using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if UNITY_EDITOR
using UnityEditor;
#endif

namespace CHTLand.SDK.Module.Component
{
    /// <summary>
    /// 跨場景傳送門元件
    /// </summary>
    [ExecuteInEditMode]
    public class ChtPortalComponent : ChtBaseComponent
    {
        [SerializeField] 
        private string portalComponentID;
        public string PortalComponentID => portalComponentID;
        //Type of component
        [HideInInspector]
        ComponentType type = ComponentType.ChtPortalComponent;
        protected override void Awake()
        {
            base.Awake();
            //Debug.LogWarning($"Chest Component ID : {ObjectID}");
        }
        void Start()
        {
            if (Application.isPlaying && CHTLandProxy.componentManager != null)
            {
                CHTLandProxy.componentManager.InitPortalComponent(this); 
            }
            Debug.Log(type.ToString());
        }
        
        #if UNITY_EDITOR
        private string myPortalPath = "Editor/Design/Prefab/Portal.prefab";
        private string myPortalStandPath = "Editor/Design/Prefab/PortalStand.prefab";
        protected override void OnValidate()
        {
            base.OnValidate();
            if (!Application.isPlaying)
            {
                // 同步 base 的 objectID 給 seatComponentID
                portalComponentID = objectID;
                UnityEditor.EditorUtility.SetDirty(this); // 確保 Inspector 顯示更新
            }
        }
        void OnEnable()
        {
            EditorApplication.update += OnEditorUpdate;
        }

        void OnDisable()
        {
            EditorApplication.update -= OnEditorUpdate;
        }

        void OnEditorUpdate()
        {
            // 如果正在Play或準備Play，就不要做任何事
            if (EditorApplication.isPlayingOrWillChangePlaymode)
            {
                return;
            }
            LockScaleSame();

            Transform myPortalTransform = transform.Find("Portal");
            if (myPortalTransform == null)
            {
                FindPrefab(myPortalPath);
            }
            Transform myPortalStandTransform = transform.Find("PortalStand");
            if (myPortalStandTransform == null)
            {
                FindPrefab(myPortalStandPath);
            }

            if (myPortalTransform != null && myPortalStandTransform != null)
            {
                BoxCollider myPortalCollider = myPortalTransform.gameObject.GetComponent<BoxCollider>();
                Vector3 myPortalColliderScale = Vector3.Scale(myPortalCollider.size, myPortalTransform.localScale);
                BoxCollider myPortalStandCollider = myPortalTransform.gameObject.GetComponent<BoxCollider>();
                Vector3 myPortalStandColliderScale = Vector3.Scale(myPortalStandCollider.size, myPortalStandTransform.localScale);

                DetectCollisions(default, default, myPortalColliderScale, myPortalTransform.position, "Portal");
                DetectCollisions(default, default, myPortalStandColliderScale, myPortalStandTransform.position,"PortalStand");
                
                InheritLockAllComponents(myPortalTransform.gameObject);
                InheritLockAllComponents(myPortalStandTransform.gameObject);
            }
        }

        #endif
    }
}