using System.Collections;
using System.Collections.Generic;
using CHTLand.SDK.Module;
using UnityEngine;

#if UNITY_EDITOR
using UnityEditor;
#endif

namespace CHTLand.SDK.Module.Component{
    /// <summary>
    /// 座位元件
    /// </summary>
    [ExecuteInEditMode]
    public class ChtSeatComponent : ChtBaseComponent
    {
        [SerializeField] 
        private string seatComponentID;
        public string SeatComponentID => seatComponentID;

        [HideInInspector]
        ComponentType type = ComponentType.ChtSeatComponent;
        protected override void Awake()
        {
            base.Awake();
            //Debug.LogWarning($"Chest Component ID : {ObjectID}");
        }
        void Start()
        {
            if (Application.isPlaying && CHTLandProxy.componentManager != null)
            {
                CHTLandProxy.componentManager.InitSeatComponent(this); 
            }
            Debug.Log(type.ToString());
        }

        #if UNITY_EDITOR
        private string mySeatPrefab = "Editor/Design/Prefab/Seat.prefab";
        private string myBackIconPath = "Editor/Design/Prefab/Back.prefab";
        private Vector3 myBackIconPosition = new Vector3(0.0f, -0.012f, 0.00f);
        private Vector3 myBackIconScale = new Vector3(0.3f, 0.3f, 0.3f);
        private Quaternion myBackIconRotation = Quaternion.Euler(-90.0f, 180.0f, 0.0f);
        private Vector3 myColliderSize = new Vector3(0.5f, 0.02f, 0.5f);
        protected override void OnValidate()
        {
            base.OnValidate();
            if (!Application.isPlaying)
            {
                // 同步 base 的 objectID 給 seatComponentID
                seatComponentID = objectID;
                UnityEditor.EditorUtility.SetDirty(this); // 確保 Inspector 顯示更新
            }
        }
        void OnEnable()
        {
            EditorApplication.update += OnEditorUpdate;
        }

        void OnDisable()
        {
            EditorApplication.update -= OnEditorUpdate;
        }

        void OnEditorUpdate()
        {
            // 如果正在Play或準備Play，就不要做任何事
            if (EditorApplication.isPlayingOrWillChangePlaymode)
            {
                return;
            }
            LockScaleSame();
            
            //生成座位元件
            Transform mySeatTransform = transform.Find("Seat");
            if ( mySeatTransform == null)
            {
                FindPrefab(mySeatPrefab);
                mySeatTransform = transform.Find("Seat");
                mySeatTransform.parent = transform;
                InheritLockAllComponents(mySeatTransform.gameObject);
            }
            
            //生成面向圖(背面)
            Transform myIconBackTransform = transform.Find("Back"); 
            if (myIconBackTransform == null)
            {
                FindPrefab(myBackIconPath);
                myIconBackTransform = transform.Find("Back");
                myIconBackTransform.parent = this.transform;
                myIconBackTransform.localPosition = myBackIconPosition;
                myIconBackTransform.localScale = myBackIconScale;
                myIconBackTransform.localRotation = myBackIconRotation;
                InheritLockAllComponents(myIconBackTransform.gameObject);
            }

            if (mySeatTransform != null)
            {
                DetectCollisions(default, default, mySeatTransform.localScale, transform.position ,"Seat");

                CreateCollider();
                BoxCollider myCollider = gameObject.GetComponent<BoxCollider>();
                myCollider.size = myColliderSize;
                myCollider.hideFlags = HideFlags.HideInInspector;
            }
            else
            {
                Debug.Log("Not find Seat!");
            }
        }

        void OnDrawGizmos()
        {
            
        }
        #endif
    }
}