using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

#if UNITY_EDITOR
using UnityEditor;
#endif

namespace CHTLand.SDK.Module.Component
{   
    /// <summary>
    /// 傳送門元件
    /// </summary> 
    [ExecuteInEditMode]
    public class ChtTeleportComponent : ChtBaseComponent
    {
        [SerializeField] 
        private string teleportComponentID; 
        public string TeleportComponentID => teleportComponentID;
        
        [HideInInspector]
        ComponentType type = ComponentType.ChtTeleportComponent;
        protected override void Awake()
        {
            base.Awake();
            teleportComponentID = objectID;
            //Debug.LogWarning($"Teleport Component ID : {ObjectID}");
        }

        public Transform targetPositionTransform; 
        public string teleportToPlaceName = "...";

        void Start()
        {
            if (Application.isPlaying && CHTLandProxy.componentManager != null)
            {
                CHTLandProxy.componentManager.InitTeleportComponent(this);
            }
            Debug.Log(type.ToString());   
        }

        private Transform targetPos;
        private string myChtTeleportCompPath = "Editor/Design/Prefab/ChtTeleportComp.prefab";
        private string myTargetStandOnPath = "Editor/Design/Prefab/TargetStandOn.prefab";
        
        #if UNITY_EDITOR

        private string previousTeleportToPlaceName = "";
        protected override void OnValidate()
        {
            base.OnValidate();
            if (!Application.isPlaying)
            {
                // 同步 base 的 objectID 給 seatComponentID
                teleportComponentID = objectID;
                UnityEditor.EditorUtility.SetDirty(this); // 確保 Inspector 顯示更新

                if(teleportToPlaceName != previousTeleportToPlaceName)
                {
                    previousTeleportToPlaceName = teleportToPlaceName;
                    SetText();
                }
            }
        }

        void OnEnable()
        {
            EditorApplication.update += OnEditorUpdate;
        }

        void OnDisable()
        {
            EditorApplication.update -= OnEditorUpdate;
        }

        void OnEditorUpdate()
        {
            // 如果正在Play或準備Play，就不要做任何事
            if (EditorApplication.isPlayingOrWillChangePlaymode)
            {
                return;
            }
            if (transform.Find("ChtTeleportComp") == null)
            {
                GameObject targetPosition = new GameObject("TargetPosition");
                targetPosition.transform.parent = this.transform;

                //創建傳送門的模型
                FindPrefab(myChtTeleportCompPath);
                //創建TargetStandOn物件
                FindPrefab(myTargetStandOnPath);
                
                //鎖定Prefab物件
                GameObject myTargetStandOn = transform.Find("TargetStandOn").gameObject;
                GameObject myChtTeleportComp = transform.Find("ChtTeleportComp").gameObject;
                InheritLockAllComponents(myTargetStandOn.gameObject);
                InheritLockAllComponents(myChtTeleportComp.gameObject);

                targetPositionTransform = transform.Find("TargetPosition");
                var targetStandOn = transform.Find("TargetStandOn");
                if (targetPositionTransform != null && targetStandOn != null)
                {
                    targetPosition.transform.localPosition = new Vector3(0.0f,1.6f,-3.4f);
                    targetStandOn.parent = targetPosition.transform;
                    targetStandOn.transform.localPosition = new Vector3(0f, 0f, 0f);
                }
            }
            if (transform.Find("TargetPosition") != null)   
            {
                targetPos = transform.Find("TargetPosition");        
            }
            else
            {
                Debug.Log("Not find TargetPosition !");
            }
            DetectCollisions(blue, red);
        }

        private void SetText()
        {
            Transform textTransform = transform.Find("ChtTeleportComp/Canvas/Panel/Text");
            if(textTransform != null)
            {
                Debug.Log("Found text");
                textTransform.gameObject.GetComponent<Text>().text = teleportToPlaceName;
                //textTransform.transform.localScale = new Vector3(0.3f, 0.3f, 0.3f);
            }
                        
        }
        private Vector3[] myPoints;

        //畫出傳送門到傳送點的線
        
        void OnDrawGizmos()
        {
            if (!Application.isPlaying)
            {
                if (targetPos == null)
                    return;
                myPoints = new Vector3[]
                {
                    transform.position,
                    targetPos.position
                };

            Gizmos.color = purple;
            Gizmos.DrawLineStrip(myPoints, false);
            }
        }
        
        MaterialPropertyBlock materialPropertyBlock;
        protected override void DetectCollisions(UnityEngine.Color? defaultColor = default, UnityEngine.Color? changeColor = default, Vector3?Collidersize = default, Vector3?MyColliderCenter = default, string ChildObjectName = null)
        {
            
            Vector3 boxSize = Collidersize ?? transform.localScale;

            //有放TransparentComp變色材質的子物件
            Transform childObjectMesh001 = transform.Find("ChtTeleportComp/Door/TeleportDoor/Group/Mesh.001");
            Transform childObjectMesh1 = transform.Find("ChtTeleportComp/Door/TeleportDoor/Group 2/Mesh 1");
            
            MeshRenderer childObjectMesh001Renderer = childObjectMesh001.gameObject.GetComponent<MeshRenderer>();
            MeshRenderer childObjectMesh1Renderer = childObjectMesh1.gameObject.GetComponent<MeshRenderer>();
            
            //創建Material Property Block
            materialPropertyBlock = new MaterialPropertyBlock();
            materialPropertyBlock.SetColor("_Color", defaultColor.Value);
            
            //設定需要變色物件Renderer的Material Property Block
            childObjectMesh001Renderer.SetPropertyBlock(materialPropertyBlock);
            childObjectMesh1Renderer.SetPropertyBlock(materialPropertyBlock);
        
            //設定overlapBox大小位置
            Vector3 overlapBoxPosition = new Vector3(transform.position.x, transform.position.y+1.25f,transform.position.z);
            Collider[] hitColliders = Physics.OverlapBox(overlapBoxPosition, new Vector3(2.75f, 3.5f, 0.34f)/2, transform.rotation, ~0);

            //根据碰撞结果切换颜色
            if (hitColliders.Length > 0)
            {
                Debug.Log("Detected collision with " + hitColliders[0].name);
                materialPropertyBlock.SetColor("_Color", changeColor.Value);
                childObjectMesh001Renderer.SetPropertyBlock(materialPropertyBlock);
                childObjectMesh1Renderer.SetPropertyBlock(materialPropertyBlock);
            }
        }
       
        #endif
        
    }
}
