using UnityEngine;

namespace CHTLand.SDK.Module.Component
{
    [ExecuteInEditMode]
    public class SceneComponentManager : MonoBehaviour, IEntryComponentProvider
    {
        public static SceneComponentManager ins;

        private void Awake()
        {
            // 编辑器模式下也初始化单例
            if (ins != null && ins != this)
            {
                DestroyImmediate(gameObject);
                return;
            }
            ins = this;
        }

        #if UNITY_EDITOR
        /// <summary>
        /// 取得Entry元件的位置
        /// </summary>
        /// <returns>返回第一个 ChtEntryComponent 的位置，如果没有，返回 Vector3.zero</returns>
        public Vector3 GetEntryPosition()
        {
            var entryComponents = FindObjectsOfType<ChtEntryComponent>();        
            if (entryComponents.Length > 0)
            {
                HandleMutipleComponent(entryComponents);
                return entryComponents[0].transform.position; 
            }
                
            Debug.LogWarning("场景中没有找到 ChtEntryComponent。");
            return Vector3.zero;
        }
        /// <summary>
        /// 取得Entry元件的Y軸旋轉角度
        /// </summary>
        /// <returns></returns>
        public float GetRotateAngleY()
        {
            var entryComponents = FindObjectsOfType<ChtEntryComponent>();
            if (entryComponents.Length > 0)
            {
                HandleMutipleComponent(entryComponents);
                return entryComponents[0].transform.rotation.eulerAngles.y;
            }
            
            Debug.Log("场景中没有找到 ChtEntryComponent。");
            return 0f;
        }
        private void HandleMutipleComponent(ChtEntryComponent[] entryComponents)
        {
            if (entryComponents.Length > 0)
            {
                //Debug.LogWarning("Disable redundant ChtEntryComponent GameObject.");
                for (int i = 1; i < entryComponents.Length; i++)
                {
                    entryComponents[i].gameObject.SetActive(false);                   
                }
            }
        }
        #endif
    }
}