using System.Threading.Tasks;
using UnityEngine;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

/// <summary>
/// 數位資產以C# API提供創作者使用
//  1.查詢使用者錢包中的 NFT item
//  2.查詢場景創作者錢包中的 NFT item
//  3.將 NFT items 從創作者轉移至一般使用者
/// </summary>

namespace CHTLand.SDK.Module.DigitalAsset
{    
    public interface IDigitalAssetApiCallback
    {
        void OnApiResponseReceived(string response);
    }

    public interface IDigitalAssetManager
    {
        /// <summary>
        /// 查詢使用者自有的 NFT items 
        /// </summary>
        /// <returns>詳細 NFT 清單</returns>        
        /// <param name="apiCallback">收到資料後要觸發的 callback</param>        
        /// 
        void GetNFTAccountID(IDigitalAssetApiCallback apiCallback);

        void GetNFTAsset(IDigitalAssetApiCallback apiCallback);
    }
}
