using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace CHTLand.SDK.Module.Input
{
    /// <summary>
    /// 攝影機管理介面，用來控制遊戲中的攝影機行為，例如震動、變焦、視角切換等。
    /// </summary>
    public interface ICameraManager
    {
        /// <summary>
        /// 套用高頻率的攝影機震動，適合短時間、低到高強度的撞擊效果。
        /// </summary>
        /// <param name="duration">震動持續時間</param>
        /// <param name="magnitude">震動強度</param>
        void Shake(float duration, float magnitude);

        /// <summary>
        /// 設定第三人稱攝影機與玩家角色的距離。
        /// </summary>
        /// <param name="distance">攝影機距離</param>
        void SetZoomDistance(float distance);

        /// <summary>
        /// 設定攝影機的視野角度（Field of View）。
        /// </summary>
        /// <param name="fov">視野角度</param>
        void SetFov(float fov);

        /// <summary>
        /// 設定攝影機相對於玩家角色的位移偏移。
        /// </summary>
        /// <param name="offset">三維空間的偏移值</param>
        void SetOffset(Vector3 offset);

        /// <summary>
        /// 切換是否使用第一人稱攝影機。
        /// </summary>
        /// <param name="isOn">是否啟用第一人稱攝影機</param>
        void ChangeToFirstPerson(bool isOn);

        /// <summary>
        /// 切換為固定位置的攝影機模式。
        /// </summary>
        void SwitchToFixedCamera();

        /// <summary>
        /// 切換為自由環視的攝影機模式（如FreeLook）。
        /// </summary>
        void SwitchToFreeLookCamera();

        /// <summary>
        /// 攝影機切換追蹤目標至指定物件。
        /// </summary>
        /// <param name="obj">要追蹤的物件</param>
        void CameraChangeTarget(GameObject obj);

        /// <summary>
        /// 攝影機切換回原本追蹤的目標。
        /// </summary>
        void CameraChangeBack();
    }
}