using UnityEngine;

namespace CHTLand.SDK.Module.Input
{
    /// <summary>
    /// 麥克風管理介面，負責開啟與關閉本地麥克風。
    /// </summary>
    public interface IMicManager
    {
        /// <summary>
        ///   <para>Start Recording with device.</para>
        /// </summary>
        /// <param name="loop">Indicates whether the recording should continue recording if lengthSec is reached, and wrap around and record from the beginning of the AudioClip.</param>
        /// <param name="lengthSec">Is the length of the AudioClip produced by the recording.</param>
        /// <param name="frequency">The sample rate of the AudioClip produced by the recording.</param>
        /// <returns>
        ///   <para>The function returns null if the recording fails to start.</para>
        /// </returns>
        public AudioClip StartLocalMic(
            bool loop = true,
            int lengthSec = 10,
            int frequency = 44100,
            bool leapSync = false
        );

        /// <summary>
        ///   <para>Stops recording.</para>
        /// </summary>
        public void EndLocalMic();

        /// <summary>
        ///   <para>Request that the user grant access to a Microphone.</para>
        /// </summary>
        public void RequestPermission();
    }
}
