
using UnityEngine;

/*Note:
1.第一個進入房間或創建者，為Master腳色，有權限可以對同步參數(CallRPC除外)修改
2.可以透過RequestAuthority主動取得權限，權限同一時間只能一個使用者持有
3.同步參數-整數，限制為10個
4.同步參數-浮點數，限制為5個
5.同步參數-字串，限制為5個
6.同步參數-物件，限制為3個
*/

namespace CHTLand.SDK.Module.Multiple
{
    /// <summary>
    /// 多人連線互動的物件
    /// </summary>
    public interface IMultiActManager
    {
        /// <summary>
        /// 重新初始化，清除所有Callback
        /// </summary>
        public void Initial();

        /// <summary>
        /// 註冊互動物件後，可取得互動物件的控制元件，並透過Callback收到同步數值改變
        /// </summary>
        /// <param name="multiActCallback">透過Callback收到同步數值改變</param>
        /// <returns></returns>
        bool RegisterCallback(IMultiActCallback multiActCallback);

        /// <summary>
        /// 主動取得存取權限
        /// </summary>
        void RequestAuthority();

        /// <summary>
        /// 主動取得存取權限
        /// </summary>
        bool CheckAuthority();

        /// <summary>
        /// 主動修改同步數值
        /// 注意:須先取得存取權
        /// </summary>
        /// <param name="i">欲修改的 整數 值，最多十個</param>
        /// <param name="f">欲修改的 浮點 值，最多五個</param>
        /// /// <param name="s">欲修改的 字串 值，最多五個</param>
        void ChangeInteger(int index, int value);
        void ChangeFloat(int index, float value);
        void ChangeString(int index, string value);

        /// <summary>
        /// 任何人都可呼叫發出一次性事件
        /// </summary>
        /// <param name="ivalue">事件傳遞 整數 值</param>
        /// <param name="svalue">事件傳遞 字串 值</param>
        void CallRPC(int ivalue, string svalue);

        /// <summary>
        /// 綁定欲進行位置與旋轉同步之物件實體
        /// </summary>
        /// <param name="index">索引值，最多三個</param>
        /// <param name="go">欲綁定物件</param>
        void BindGameObject(int index, GameObject go);
        
        /// <summary>
        /// 取得紀錄同步位置與旋轉的物件實體
        /// </summary>
        /// <param name="index">索引值，最多三個</param>
        /// <returns>回傳紀錄物件</returns>
        GameObject GetGameObject(int index);
    }

    /// <summary>
    /// 透過Callback收到同步數值改變
    /// 注意:需先向IMultiActObjectManager註冊此元件，並自行實作內容
    /// </summary>
    public interface IMultiActCallback
    {
        /// <summary>
        /// 主動取得或失去存取權限，會收到此通知
        /// </summary>
        /// <param name="hasAuthority">true:有權限，false:無權限</param>
        void OnAuthorityChanged(bool hasAuthority);

        /// <summary>
        /// 當同步數值改變時，會收到通知
        /// </summary>
        /// <param name="i">當前最新 整數 值</param>
        /// <param name="s">當前最新 字串 值</param>
        /// <param name="f">當前最新 浮點 值</param>
        void OnIntegerChanged(int index, int value);
        void OnStringChanged(int index, string value);
        void OnFloatChanged(int index, float value);
        void OnRPC_Called(int ivalue, string svalue);
    }
}