using System;
using UnityEngine;

namespace CHTLand.SDK.Module.Network
{
    /// <summary>
    /// NetworkRequestManager介面
    /// </summary>
    public interface INetworkRequestManager
    {
        /// <summary>
        /// 取得驗證過的網路請求物件
        /// </summary>
        /// <returns>網路請求物件</returns>
        IValidatedWebRequest GetValidatedWebRequest();
        void WebSocketConnect(string url, Action onOpenCallback, Action<byte[]> onMessageCallback, Action<string> onErrorCallback, Action onCloseCallback);
        void WebSocketSend(byte[] bytes);
        void WebSocketSendText(string message);
        void WebSocketDisconnect();
    }
}