using UnityEngine;
using UnityEngine.Networking;

namespace CHTLand.SDK.Module.Network
{
    /// <summary>
    /// ValidatedWebRequest介面
    /// </summary>
    public interface IValidatedWebRequest
    {
        /// <summary>
        /// 發送驗證過的GET請求
        /// </summary>
        /// <param name="url">請求的URL</param>
        /// <returns>如果URL驗證通過返回UnityWebRequest物件，否則返回null</returns>
        UnityWebRequest Get(string url);
        
        /// <summary>
        /// 發送驗證過的POST請求
        /// </summary>
        /// <param name="url">請求的URL</param>
        /// <param name="postData">要傳送的資料</param>
        /// <returns>如果URL驗證通過返回UnityWebRequest物件，否則返回null</returns>
        UnityWebRequest Post(string url, string postData, string contentType);

        /// <summary>
        /// 發送驗證過的POST請求(使用表單資料)
        /// </summary>
        /// <param name="url">請求的URL</param>
        /// <param name="formData">要傳送的表單資料</param>
        /// <returns>如果URL驗證通過返回UnityWebRequest物件，否則返回null</returns>
        UnityWebRequest Post(string url, WWWForm formData);
    }
}