using UnityEngine;

namespace CHTLand.SDK.Module.Player
{
    using Module.User;

    /// <summary>
    /// Avatar控制介面
    /// </summary>
    public interface IAvatar
    {
        /// <summary>
        /// 播放自定義動畫
        /// </summary>
        /// <param name="clipName">動畫名稱</param>
        /// <param name="loop">重複播放與否，必須和Animation Clip中Loop Time屬性一致方能正常運作。</param>
        /// <param name="reset">播放完成是否回到預設狀態動畫，必須搭配loop為false才有作用。</param>
        /// <param name="transitionTime">和現有動畫的移轉插補時間</param>
        void PlayAnimationClip(string clipName, bool loop = false, bool reset = true, float transitionTime = 0.25f);

        /// <summary>
        /// 停止自定義動畫
        /// </summary>
        void StopAnimationClip();

        /// <summary>
        /// 掛載配件
        /// </summary>
        /// <param name="goName">配件GameObject名稱</param>
        /// <param name="boneToAttach">掛載到的骨頭</param>
        /// <param name="position">配件的local position</param>
        /// <param name="rotation">配件的local rotation</param> 
        /// <param name="scale">配件的local scale</param>
        bool AddAttachment(string goName, HumanBodyBones boneToAttach, Vector3 position, Quaternion rotation, Vector3 scale);

        /// <summary>
        /// 卸除配件
        /// </summary>
        /// <param name="goName">配件GameObject名稱</param>
        bool RemoveAttachment(string goName, HumanBodyBones boneToDetach);

        /// <summary>
        /// 置換Avatar模型
        /// </summary>
        /// <param name="goName">Avatar GameObject名稱</param>
        /// <param name="gender">性別</param>
        bool ReplaceAvatar(string goName, Gender gender);

        /// <summary>
        /// 恢復預設Avatar模型
        /// </summary>
        void ResetAvatar();
    }

}