using CHTLand.SDK.Module.User;
using UnityEngine;
using CHTLand;
using System.Collections.Generic;
namespace CHTLand.SDK.Module.Player
{
    /// <summary>
    /// 多人連線互動的使用者類別
    /// </summary>
    public interface IPlayer : IPlayerMoveControl, IPlayerStatusControl
    {
        /// <summary>
        /// 取得使用者ID
        /// </summary>
        /// <returns>User ID</returns>
        string GetUserId();

        /// <summary>
        /// 取得使用者暱稱
        /// </summary>
        /// <returns>暱稱字串</returns>
        string GetNickName();

        /// <summary>
        /// 取得使用者物件 Tag名稱
        /// </summary>
        /// <returns>使用者物件 Tag 名稱字串</returns>
        string GetTagName();

        /// <summary>
        /// 取得使用者的Avatar
        /// </summary>
        /// <returns>Avatar物件</returns>
        /// 
        IAvatar GetAvatar();
        // <summary>
        /// 取得Local 控制的Player
        /// </summary>
        /// <returns>GameObject Of Local Player</returns> 
        GameObject GetLocalPlayerObject();
    
        /// <summary>
        /// 取得網路變數控制器
        /// </summary>
        /// <returns></returns>
        List<PlayerInfo> GetPlayers();

    }

 /// <summary>
        /// 玩家資料結構
        /// </summary>
        /// <returns></returns> 
    public struct PlayerInfo
    {
        // <summary>
        /// 玩家實體
        /// </summary>
        public GameObject ObjPlayer;
        // <summary>
        /// 玩家名稱
        /// </summary>
        public string UserName;
        // <summary>
        /// 玩家ＩＤ
        /// </summary>
        public string UserID;
        // <summary>
        /// 玩家性別
        /// </summary>
        public string Gender;
        // <summary>
        /// 玩家類型
        /// </summary>
        public string PlayerType;
        // <summary>
        /// 玩家狀態
        /// </summary>
        public string PlayerStatus;
        // <summary>
        /// 玩家ＨＰ值
        /// </summary>
        public int playerHP;
    }


}