using UnityEngine;

namespace CHTLand.SDK.Module.Player
{
    /// <summary>
    /// 使用者加入相機元件
    /// </summary>
    public interface IPlayerCamera
    {
        /// <summary>
        /// 設定相機為第一人稱
        /// </summary>
        /// <param name="isEnabled">使用/不使用</param>
        /// <returns></returns>
        bool ChangeToFirstPerson​(bool isEnabled);
        /// <summary>
        /// 設定相機fov
        /// </summary>
        /// <param name="fov">Fov數值</param>
        /// <returns></returns>
        bool SetFov​(float fov);
        /// <summary>
        /// 設定相機offset
        /// </summary>
        /// <param name="offset">offset數值</param>
        /// <returns></returns>
        bool SetOffset​	(float offset);

        /// <summary>
        /// 設定相機distance
        /// </summary>
        /// <param name="distance">相機distance</param>
        /// <returns></returns>
        bool SetZoomDistance (float distance);

        /// <summary>
        /// 設定相機搖晃程度
        /// </summary>
        /// <param name="magnitude">搖晃程度</param>
        /// <returns></returns>
        bool Shake​	(int magnitude);
    }

}