using UnityEngine;

namespace CHTLand.SDK.Module.Player
{
    /// <summary>
    /// 使用者加入SESSION ROOM狀態元件
    /// </summary>
    public interface IPlayerMoveControl
    {
        /// <summary>
        /// 設定Avatar走路速度
        /// </summary>
        /// <returns>成功或失敗</returns>
         /// <param name="speed">速度</param>
        bool SetWalkSpeed(float speed);

       /// <summary>
        /// 設定Avatar跑步速度
        /// </summary>
        /// <returns>成功或失敗</returns>
         /// <param name="speed">速度</param>
        bool SetRunSpeed(float speed);

         /// <summary>
        /// 設定Avatar瞬移距離閾值
        /// </summary>
        /// <returns>成功或失敗</returns>
         /// <param name="distance">距離(公尺)</param>
        bool SetTeleportThreadhold(int distance);

        /// <summary>
        /// 設定Avatar爬牆速度
        /// </summary>
        /// <returns>成功或失敗</returns>
         /// <param name="speed">速度</param>
        bool SetClimbSpeed(float speed);

          /// <summary>
        /// 設定Avatar跳起速度
        /// </summary>
        /// <returns>成功或失敗</returns>
         /// <param name="height">高度</param>
        bool SetJumpHeight(float height);

          /// <summary>
        /// 設定Avatar出現位置
        /// </summary>
        /// <returns>成功或失敗</returns>
         /// <param name="position">Avatar出現位置</param>
        bool SetAvatarPosition(Vector3 position);

         /// <summary>
        /// 設定Avatar不能移動
        /// </summary>
        /// <returns>成功或失敗</returns>
         /// <param name="isFrozen">解凍/結凍 Avatar 移動</param>
        bool SetAvatarFrozen(bool isFrozen);


        
    }

}