using UnityEngine;

namespace CHTLand.SDK.Module.Player
{
    /// <summary>
    /// 使用者加入SESSION ROOM狀態元件
    /// </summary>
    public interface IPlayerNetworkControl
    {
        /// <summary>
        /// 取得是否是本地端控制權
        /// </summary>
        /// <returns>成功或失敗</returns>
 
        bool hasControl();

       /// <summary>
        /// 宣告數值型網路變數
        /// </summary>
        /// <returns>設定值</returns>
         /// <param name="defaultvalue">初始資料</param>
        int NetworkVariableInt(int defaultvalue);

         /// <summary>
        /// 宣告文字型網路變數
        /// </summary>
        /// <returns>設定值</returns>
         /// <param name="defaultvalue">初始資料</param>
        string NetworkVariableStr(string defaultvalue);

        /// <summary>
        /// 宣告浮點型網路變數
        /// </summary>
        /// <returns>設定值</returns>
         /// <param name="defaultvalue">初始資料</param>
        string NetworkVariableFloat(float defaultvalue);

      

        
    }

}