using System.Collections.Generic;
using UnityEngine;
using CHTLand;
namespace CHTLand.SDK.Module.Player
{
  /// <summary>
  /// 使用者加入SESSION ROOM狀態元件
  /// </summary>
  public interface IPlayerStatusControl
  {
    /// <summary>
    /// 設定Player Avatar角色類別
    /// </summary>
    /// <returns>成功或失敗</returns>
    /// <param name="playerType">角色類別</param>
    bool SetPlayerType(string playerType);
    /// <summary>
    /// 取得Player Avatar角色類別
    /// </summary>
    /// <returns>Avatar角色類別</returns>
    System.String GetPlayerType();
    /// <summary>
    /// 設定Player Avatar是否使用重力系統
    /// </summary>
    /// <returns>成功或失敗</returns>
    /// <param name="isEnabled">使用/不使用</param>
    bool SetUseGravity(bool isEnabled);

    /// <summary>
    /// 設定Player Avatar是否使用碰撞系統
    /// </summary>
    /// <returns>成功或失敗</returns>
    /// <param name="isEnabled">使用/不使用</param>
    bool SetUseCollider(bool isEnabled);

    /// <summary>
    /// 設定Player Avatar目前狀態
    /// </summary>
    /// <returns>成功或失敗</returns>
    /// <param name="playStatus">使用者狀態</param>
    bool SetPlayerStatus(string playStatus);
    /// <summary>
    /// 取得Player Avatar目前狀態
    /// </summary>
    /// <returns>Avatar目前狀態</returns>
    /// <param name="playStatus"></param>
    System.String GetPlayerStatus();
    /// <summary>
    /// 設定Player Avatar生命值狀態
    /// </summary>
    /// <returns>成功或失敗</returns>
    /// <param name="hp">使用者生命值</param>
    bool SetHP(int hp);
    /// <summary>
    /// 設定Player 名牌是否顯示
    /// </summary>
    /// <returns>成功或失敗</returns>
    /// <param name="isShowed">是否要展示名牌，True:要，False:不要</param>
    bool SetBandShow(bool isShowed);
    /// <summary>
    /// 設定Player Avatar生命值狀態，回傳-1表示方法失敗
    /// </summary>
    /// <returns>HP的數值</returns> 
    int GetHP();
    /// <summary>
    /// 取得Player Avatar Transform資料
    /// </summary>
    /// <returns>Avatar Transform</returns> 
    Transform GetPlayerTransform();
    
 

  }

}