using System.Threading.Tasks;
using UnityEngine;

namespace CHTLand.SDK.Module.User
{
    /// <summary>
    /// 任務管理器介面，負責處理使用者任務的相關操作。
    /// </summary>
    public interface IMissionManager
    {
        /// <summary>
        /// 將指定的任務標記為已完成。
        /// </summary>
        /// <param name="templateId">任務模板的唯一識別碼。</param>
        /// <param name="eventId">任務事件的識別碼，用於區分任務實例。</param>
        /// <returns>回傳一個 Task，當操作成功時結果為 true，失敗則為 false。</returns>
        Task<bool> SetMissionDone(string templateId, string eventId);
    }
}