using UnityEngine;

namespace CHTLand.SDK.Module.User
{
    /// <summary>
    /// 性別列舉
    /// </summary>
    public enum Gender
    {
        Male,
        Female
    }

    /// <summary>
    /// UserManager介面
    /// </summary>
    public interface IUserManager
    {
        /// <summary>
        /// 取得使用者暱稱
        /// </summary>
        /// <returns>暱稱</returns>
        string GetNickname();

        /// <summary>
        /// 取得使用者性別
        /// </summary>
        /// <returns>Female or Male</returns>
        Gender GetGender();

        /// <summary>
        /// 取得使用者頭像
        /// </summary>
        /// <returns>頭像紋理貼圖</returns>
        void GetPortrait(IUserPortraitCallback callback);
    }

    /// <summary>
    /// 透過Callback收到Portrait texture
    /// </summary>
    public interface IUserPortraitCallback
    {
        /// <summary>
        /// 取得頭像紋理成功
        /// </summary>
        /// <param name="texture">Portrait 紋理物件</param>
        void OnLoadComplete(Texture2D texture);

        /// <summary>
        /// 取得頭像紋理失敗
        /// </summary>
        /// <param name="error">錯誤原因</param>
        void OnLoadFailed(string error);
    }
}