using System.Collections;
using System.Collections.Generic;
using Cinemachine;
using UnityEngine;

public class BasicController : MonoBehaviour
{
    float moveRate = 2.0f;
    float moveRateY = 0.025f;
    float avatarMoveRate = 10.0f;
    float mousePos = -1f;
    bool moveLock = false;
    float walkSpeed = 5f;
    float turnSmoothVelocity;
    float turnSmoothTime = 0.025f;

    GameObject vcam;
    CharacterController controller;
    // Start is called before the first frame update
    void Start()
    {
        controller = GetComponent<CharacterController>();
        vcam = GameObject.Find("CMvcam1");
        if(vcam != null)
        {
            var freeLook = vcam.GetComponent<CinemachineFreeLook>();
            //freeLook.Follow = transform.Find("Shoulder");
            //freeLook.LookAt = transform.Find("Shoulder");
        }
    }
    private void Update()
    {
        if (!moveLock)
        {
            DragCamera();
            ZoomCamera();
            KeyboardMovement();
        }
    }
    private void DragCamera()
    {
        var freeLook = vcam.GetComponent<CinemachineFreeLook>();
        if (freeLook == null)
            print("freeLook is null");
        if (Input.GetMouseButton(0))
        {
            freeLook.m_XAxis.Value += Input.GetAxis("Mouse X") * moveRate;
            freeLook.m_YAxis.Value -= Input.GetAxis("Mouse Y") * moveRateY;
            return;
        }
    }
    private void ZoomCamera()
    {
        float scale = -1.0f;
        var freeLook = vcam.GetComponent<CinemachineFreeLook>();
        if (freeLook.m_Lens.FieldOfView <= 15.0f)
        {
            if (Input.mouseScrollDelta.y < 0)
                freeLook.m_Lens.FieldOfView += Input.mouseScrollDelta.y * scale;
        }
        else if (freeLook.m_Lens.FieldOfView >= 60.0f)
        {
            if (Input.mouseScrollDelta.y > 0)
                freeLook.m_Lens.FieldOfView += Input.mouseScrollDelta.y * scale;
        }
        else
            freeLook.m_Lens.FieldOfView += Input.mouseScrollDelta.y * scale;
    }
    private void KeyboardMovement()
    {
        float horizonal = Input.GetAxis("Horizontal");
        float vertical = Input.GetAxis("Vertical");

        // Q 向下 (-Y), E 向上 (+Y)
        float upDown = 0f;
        if (Input.GetKey(KeyCode.E)) upDown = 1f;
        if (Input.GetKey(KeyCode.Q)) upDown = -1f;

        Vector3 direction = new Vector3(horizonal, 0.0f, vertical).normalized;

        // 如果只有上/下移動（QE），不旋轉也不水平移動
        if (direction.magnitude <= 0.1f && upDown != 0f)
        {
            Vector3 verticalMove = Vector3.up * upDown;
            controller.Move(verticalMove * walkSpeed * Time.deltaTime);
            return;
        }

        // 否則照原本方式處理轉向與平面移動
        if (direction.magnitude > 0.1f)
        {
            float targetAngle = Mathf.Atan2(direction.x, direction.z) * Mathf.Rad2Deg + Camera.main.transform.eulerAngles.y;
            float angle = Mathf.SmoothDampAngle(transform.eulerAngles.y, targetAngle, ref turnSmoothVelocity, turnSmoothTime);
            Vector3 moveDir = Quaternion.Euler(0f, targetAngle, 0f) * Vector3.forward;

            // 合併 XZ + Y 軸方向
            Vector3 finalMove = (moveDir + Vector3.up * upDown).normalized;

            transform.rotation = Quaternion.Euler(0f, angle, 0f);
            controller.Move(finalMove * walkSpeed * Time.deltaTime);
        }

        // Running or Walking
        walkSpeed = Input.GetKey(KeyCode.LeftShift) ? 10f : 5f;
    }
    public void SetMoveLock(bool enabled)
    {
        moveLock = enabled;
    }

}
