#if UNITY_EDITOR
using UnityEditor;
using UnityEngine;
using UnityEngine.EventSystems;
using System;
using CHTLand.SDK.Editor;

public class CanvasFunction : MonoBehaviour
{
    private static bool shouldRunTestAfterExit = false;

    public void TestSandbox()
    {
        if (EditorApplication.isPlaying)
        {
            Debug.Log("Exiting Play Mode...");
            shouldRunTestAfterExit = true;
            EditorApplication.isPlaying = false;
        }
        else
        {
            RunEditorTest();
        }
    }

    [InitializeOnLoadMethod]
    static void OnLoad()
    {
        // 註冊 playMode 狀態變更事件
        EditorApplication.playModeStateChanged += OnPlayModeStateChanged;
    }

    static void OnPlayModeStateChanged(PlayModeStateChange state)
    {
        // 當從 Play Mode 回到 Edit Mode 時執行
        if (state == PlayModeStateChange.EnteredEditMode && shouldRunTestAfterExit)
        {
            shouldRunTestAfterExit = false;
            RunEditorTest();
        }
    }

    static void RunEditorTest()
    {
        Debug.Log("[Editor] Running TestProcess...");
        Utils.TestProcess();
    }

    void Awake()
    {
        EnsureEventSystemExists();
    }

    private void EnsureEventSystemExists()
    {
        if (FindObjectOfType<EventSystem>() == null)
        {
            GameObject eventSystem = new GameObject("EventSystem", typeof(EventSystem), typeof(StandaloneInputModule));
        }
    }

    public void ClosePanel()
    {
        gameObject.SetActive(false);
    }
}
#endif