using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public static class Initializer
{
    [RuntimeInitializeOnLoadMethod]
    static void OnPlayModeStarted()
    {
        Debug.Log("Play 模式已啟動，執行函數！");
        LoadMovement();
        LoadWarning();
    }

    static void LoadMovement()
    {
        Debug.Log("這是你的自訂函數");

        GameObject prefab = Resources.Load<GameObject>("Movement");
        if (prefab != null)
        {
            GameObject instance = Object.Instantiate(prefab);
            instance.name = "[Test] MovementObj";
        }
        else
        {
            Debug.LogError("找不到 prefab，請確認 Resources 資料夾中是否有 Movement");
        }
    }
    static void LoadWarning()
    {
        Debug.Log("這是你的自訂函數");

        GameObject prefab = Resources.Load<GameObject>("Warning");
        if (prefab != null)
        {
            GameObject instance = Object.Instantiate(prefab);
            instance.name = "[Test] Warning";
        }
        else
        {
            Debug.LogError("找不到 prefab，請確認 Resources 資料夾中是否有 Warning");
        }
    }
}
