using System.Collections;
using System.Collections.Generic;
using CHTLand.SDK.Module;
using CHTLand.SDK.Module.User;
using TutorialComponent;
using UnityEngine;

namespace ExamplePlayerModule
{
    public class AvatarController : MonoBehaviour
    {
        public Animator demoAnimator;
        public LevelManager levelManager;

        // Start is called before the first frame update
        void Start()
        {

        }

        // Update is called once per frame
        void Update()
        {

        }

        public void ReplaceAvatar()
        {
            CHTLandProxy.playerManager.GetLocalPlayer().GetAvatar().ReplaceAvatar("Seed-san", Gender.Male);
            levelManager.CompleteLevel1();
        }

        public void AddAttachment()
        {
            CHTLandProxy.playerManager.GetLocalPlayer().GetAvatar().AddAttachment("Microphone",
                    HumanBodyBones.LeftHand,
                    new Vector3(-0.178f, 0.11f, 0.076f),
                    Quaternion.Euler(0f, -173.295f, 90f),
                    new Vector3(1.6f, 1.6f, 1.6f)
                    );
            levelManager.CompleteLevel2();
        }


        public void PlayCustomAnimation()
        {
            if (demoAnimator != null)
            {
                demoAnimator.Play("Cheering", 0, 0f);
            }
            CHTLandProxy.playerManager.GetLocalPlayer().GetAvatar().PlayAnimationClip("Cheering", true);
            levelManager.CompleteLevel3();
        }
    }
}
