using System.Collections;
using UnityEngine;
using System.Collections.Generic;
using CHTLand.SDK.Module;

namespace TutorialComponent
{
    public class LevelManager : MonoBehaviour
    {
        [Header("關卡設定")]
        public GameObject level1;
        public GameObject level2;
        public GameObject level3;
        public GameObject clearCanvas;

        public void CompleteLevel1()
        {
            // CHTLandProxy.missionManager.SetMissionDone("161", "45");
            StartCoroutine(CompleteLevelWithDelay(level1, 2f));
        }

        public void CompleteLevel2()
        {
            // CHTLandProxy.missionManager.SetMissionDone("161", "46");
            StartCoroutine(CompleteLevelWithDelay(level2, 2f));
        }

        public void CompleteLevel3()
        {
            // CHTLandProxy.missionManager.SetMissionDone("161", "47");
            clearCanvas.SetActive(true);
        }

        private IEnumerator CompleteLevelWithDelay(GameObject level, float sec)
        {
            // 延遲
            yield return new WaitForSeconds(sec);

            // 關閉目前關卡
            level.SetActive(false);
        }
    }
}

