using System.Collections;
using UnityEngine;
using System.Collections.Generic;
using CHTLand.SDK.Module;

namespace TutorialComponent{
    public class LevelManager : MonoBehaviour
    {
        [Header("關卡設定")]
        public GameObject[] eventObjects; // 關卡內的所有事件物件 (需要 Collider is Trigger)
        public GameObject[] triggerObjects; // 要改變材質的 Trigger 物件
        public Material completedMaterial; // 完成Event後TriggerObj的粉色材質
        public Material eventCompletedMaterial; // 完成Event後的灰色材質
        public GameObject nextLevel; // 下一個關卡的群組
        private int eventsCompleted = 0; // 已觸發的事件數量
        private bool levelCompleted = false;
        public GameObject TextGroup;
        private HashSet<GameObject> completedEvents = new HashSet<GameObject>();

        public void CompleteEvent(GameObject eventObject)
        {
            if (levelCompleted || completedEvents.Contains(eventObject)) return; // 如果關卡已完成，退出

            // 檢查是否為有效事件物件
            for (int i = 0; i < eventObjects.Length; i++)
            {
                if (eventObjects[i] == eventObject)
                {
                    // 如果該事件尚未完成
                    Renderer eventRenderer = eventObjects[i].GetComponent<Renderer>();
                    if (eventRenderer.material.color != Color.gray)
                    {
                        if (eventCompletedMaterial != null)
                        {
                            eventRenderer.material = eventCompletedMaterial;
                        }
                        else
                        {
                            eventRenderer.material.color = Color.gray; // 設置為灰色表示完成
                        }
                        eventsCompleted++;
                        completedEvents.Add(eventObject);
                        Debug.Log($"Event completed: {eventObject.name}. Total completed: {eventsCompleted}/{eventObjects.Length}");
                    }

                    // 確保更新對應的 Trigger 物件材質
                    if (i < triggerObjects.Length && triggerObjects[i] != null && triggerObjects[i].TryGetComponent(out Renderer triggerRenderer))
                    {
                        triggerRenderer.material = completedMaterial;
                    }

                    // 如果所有事件都完成
                    if (eventsCompleted == eventObjects.Length)
                    {
                        CompleteLevel(); // 調用完成關卡的方法
                    }

                    return; // 結束方法
                }
            }
        }

        private void CompleteLevel()
        {
            if (!levelCompleted) // 确保只执行一次
            {
                levelCompleted = true; // 标记关卡已完成
                StartCoroutine(CompleteLevelWithDelay(2f)); // 启动协程
            }
        }

        private IEnumerator CompleteLevelWithDelay(float sec)
        {
            // 確保事件物件材質完成更新
            for (int i = 0; i < eventObjects.Length; i++)
            {
                //完成關卡時將eventObject的顏色變成灰色
                Renderer renderer = eventObjects[i]?.GetComponent<Renderer>();
                if (renderer != null && renderer.material.color != Color.gray)
                {
                    renderer.material.color = Color.gray;
                }

                Renderer CompleteRenderer = triggerObjects[i]?.GetComponent<Renderer>();
                if (CompleteRenderer != null && CompleteRenderer.material != completedMaterial)
                {
                    CompleteRenderer.material = completedMaterial;
                }
    
            }

            // 延遲
            yield return new WaitForSeconds(sec);

            // 關閉當前關卡並啟用下一關
            if (nextLevel != null)
            {
                nextLevel.SetActive(true);
                CompleteLv1();
            }
            else
            {
                CompleteLv2();
                Debug.Log("Last Level.");
                yield break;
            }
            TextGroup.SetActive(false);
            gameObject.SetActive(false);
        }
        private void CompleteLv1()
        {
            // CHTLandProxy.missionManager.SetMissionDone("173", "63");
        }
        private void CompleteLv2()
        {
            // CHTLandProxy.missionManager.SetMissionDone("173", "64");
        }
    }
}

