using CHTLand.SDK.Module;
using UnityEngine;
using UnityEngine.UI;

namespace TutorialMultiple
{
    public class ExampleActBindGO : MonoBehaviour
    {
        [SerializeField] private Transform ball;
        [SerializeField] private Transform target;
        [SerializeField] private MeshRenderer targetMeshRender;
        [SerializeField] private Material red;
        [SerializeField] private Material green;
        [SerializeField] private float speed;
        [SerializeField] private float radius;


         [SerializeField] private Button btnBindGo;

        private float angle;

        public void ChangeBindGOTransform()
        {
            float x = target.position.x + Mathf.Cos(angle) * radius;
            float y = target.position.y;
            float z = target.position.z + Mathf.Sin(angle) * radius;
            ball.position = new Vector3(x, y, z);
            ball.LookAt(target);
            angle += speed * Time.deltaTime;

            targetMeshRender.material = red;
        }

        public void ChangeBindGOTransform(Transform t)
        {
            ball.transform.position = t.position;
            ball.transform.rotation = t.rotation;

            targetMeshRender.material = green;
        }

        public void BindGOToSync()
        {
            //具備權限者，才可以綁定物件
            if (CHTLandProxy.multiActManager.CheckAuthority()) 
                CHTLandProxy.multiActManager.BindGameObject(1, ball.gameObject);
        }

        public void GetAuthor()
        {
            CHTLandProxy.multiActManager.RequestAuthority();
        }

        public void CheckAuthorState(bool b)
        {
            btnBindGo.interactable = b;
            
        }


        void Start()
        {

        }

        void Update()
        {

        }
    }
}
