using System.Collections;
using CHTLand.SDK.Module;
using CHTLand.SDK.Module.Multiple;
using UnityEngine;

namespace TutorialMultiple
{
    public class ExampleActCallback : MonoBehaviour, IMultiActCallback
    {
        [SerializeField] private ExampleActChangeImg exampleActChangeImg;
        [SerializeField] private ExampleActCallRPC exampleActCallRPC;
        [SerializeField] private ExampleActBindGO exampleActBindGO;

        public void OnAuthorityChanged(bool hasAuthority)
        {
            exampleActChangeImg.CheckAuthorState(hasAuthority);
            exampleActBindGO.CheckAuthorState(hasAuthority);
        }

        public void OnFloatChanged(int index, float value)
        {

        }

        public void OnIntegerChanged(int index, int value)
        {
            exampleActChangeImg.ChangeImgIndexByCallback(value);
        }

        public void OnRPC_Called(int ivalue, string svalue)
        {
            exampleActCallRPC.StartSwitchFlower();
        }

        public void OnStringChanged(int index, string value)
        {

        }

        private IEnumerator DelayRegisterCallbackAndGetAuthor()
        {
            //延遲等待物件初始化完成
            yield return null;
            CHTLandProxy.multiActManager.RegisterCallback(this);

            //確認是否為房主(創建房間者)
            //再次取得並確保修改權限
            yield return new WaitForSeconds(1.0f);
            if (CHTLandProxy.multiConnectManager.CheckIsMaster())
                CHTLandProxy.multiActManager.RequestAuthority();

            bool b  = CHTLandProxy.multiActManager.CheckAuthority();
            exampleActChangeImg.CheckAuthorState(b);
            exampleActBindGO.CheckAuthorState(b);
        }

        void Start()
        {
            StartCoroutine(DelayRegisterCallbackAndGetAuthor());
        }


        void Update()
        {
            //具備權限者，主動修改同步物件位置
            if (CHTLandProxy.multiActManager.CheckAuthority())
            {
                exampleActBindGO.ChangeBindGOTransform();
            }
            else //無權限者，取得同步物件位置覆寫
            {
                exampleActBindGO.ChangeBindGOTransform(
                    CHTLandProxy.multiActManager.GetGameObject(1).transform);
            }
        }
    }
}
