using CHTLand.SDK.Module;
using UnityEngine;
using UnityEngine.UI;

namespace TutorialMultiple
{
    public class ExampleActChangeImg : MonoBehaviour
    {
        [SerializeField] private Image imageToSwitch;
        [SerializeField] private Sprite[] imgs;

        [SerializeField] private Button btnPrev;
        [SerializeField] private Button btnNext;
        private int currentIndex = 0;

        public void ChangeImgIndexByCallback(int i)
        {
            if (i < 0 || i > 2) return;
            imageToSwitch.sprite = imgs[i];
        }

        private bool mission = false;
        //具備權限者，才可以修改圖片索引
        public void ChangeImgToNext()
        {
            if (CHTLandProxy.multiActManager.CheckAuthority())
            {
                if (currentIndex == 2) return;
                else currentIndex++;
                CHTLandProxy.multiActManager.ChangeInteger(1, currentIndex);
            }
            if (!mission)
            {
                mission = true;
                // CHTLandProxy.missionManager.SetMissionDone("241", "54");
            }
        }

        //具備權限者，才可以修改圖片索引
        public void ChangeImgToPrev()
        {
            if (CHTLandProxy.multiActManager.CheckAuthority())
            {
                if (currentIndex == 0) return;
                else currentIndex--;
                CHTLandProxy.multiActManager.ChangeInteger(1, currentIndex);
            }
        }

        public void GetAuthor()
        {
            CHTLandProxy.multiActManager.RequestAuthority();
        }

        public void CheckAuthorState(bool b)
        {
            btnPrev.interactable = b;
            btnNext.interactable = b;
        }

        void Start()
        {

        }

        void Update()
        {

        }
    }
}
