using CHTLand.SDK.Module;
using CHTLand.SDK.Module.Multiple;
using UnityEngine;
using UnityEngine.UI;

namespace TutorialMultiple
{
    public class ExampleChangeVoice : MonoBehaviour
    {
        [SerializeField]private Button[] btnChannels;
        [SerializeField]private Button btn2D;
        [SerializeField]private Button btn3D;

        public void ChangeVoiceChannel(int channel)
        {
            foreach(Button  btn in btnChannels)
                btn.interactable = true;
            CHTLandProxy.multiConnectManager.ChangeVoiceChannel(channel);
            btnChannels[channel].interactable = false;
        }

        public void ChangeVoiceTo2D()
        {
            btn2D.interactable = false;
            btn3D.interactable = true;
            CHTLandProxy.multiConnectManager.ChangeVoiceType(VoiceType.TotalArea);
        }


        public void ChangeVoiceTo3D()
        {
            btn2D.interactable = true;
            btn3D.interactable = false;
            CHTLandProxy.multiConnectManager.ChangeVoiceType(VoiceType.PartArea_5M);
        }

        void Start()
        {
        
        }

        void Update()
        {
        
        }
    }
}
