using System.Linq;
using System;
using TMPro;
using UnityEngine;
using CHTLand.SDK.Module;
using CHTLand.SDK.Module.Multiple;
using System.Text;


namespace TutorialMultiple
{
    public class ExampleConnect : MonoBehaviour
    {
        [SerializeField] private TMP_Text txtRoomName;
        [SerializeField] private TMP_Text txtCloseRoom;

        private static System.Random random = new System.Random();
        public static string RandomString(int length)
        {
            var str = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
            var builder = new StringBuilder();
            for (var i = 0; i < length; i++)
            {
                builder.Append(str[random.Next(0, str.Length)]);
            }
            return builder.ToString();
        }

        public void ClickConnectRoom()
        {
            CHTLandProxy.multiConnectManager.Connect(ConnectType.Create, txtRoomName.text);
        }

        public void ClickJoinRoom()
        {
            CHTLandProxy.multiConnectManager.Connect(ConnectType.RandomJoin);
        }

        public void ClickCloseRoom()
        {
            txtCloseRoom.text = "CloseRoom:" + CHTLandProxy.multiConnectManager.CloseCurrentRoom();
        }

        public void ClickDisConnectRoom()
        {
            CHTLandProxy.multiConnectManager.DisConnect();
        }

        void Start()
        {
            txtRoomName.text = "NewRoom_" + RandomString(5);
        }

        void Update()
        {

        }
    }
}
