using System.Collections;
using CHTLand.SDK.Module;
using CHTLand.SDK.Module.Multiple;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

namespace TutorialMultiple
{
    public class ExampleGetRoomInfo : MonoBehaviour, IMultiConnectCallback
    {
        [SerializeField] private TMP_Text txtRoomInfo;
        [SerializeField] private TMP_Text txtConnectState;
        [SerializeField] private Button checkButton;
        private string master;

        public void OnConnectStateChanged(ConnectState connectState)
        {
            Debug.Log("OnConnectStateChanged:" + connectState.ToString());
            txtConnectState.text = "State:" + connectState.ToString();
        }

        public void OnPlayersChange(int count)
        {
            CHTSessionInfo cHTSessionInfo = CHTLandProxy.multiConnectManager.GetConnectedRoom();
            txtRoomInfo.text = "Name:" + cHTSessionInfo.Name + "\n" +
                            "Player:" + cHTSessionInfo.PlayerCount + "/" + cHTSessionInfo.MaxPlayers + "\n" +
                            master;
        }

        private IEnumerator DelayGetRoomInfoAndRegisterCallback()
        {
            //延遲等待物件初始化完成
            yield return null;
            master = CHTLandProxy.multiConnectManager.CheckIsMaster() ? "You are Master!" : "You are not Master~";

            CHTLandProxy.multiConnectManager.RegisterCallback(this);

            CHTSessionInfo cHTSessionInfo = CHTLandProxy.multiConnectManager.GetConnectedRoom();
            txtRoomInfo.text = "Name:" + cHTSessionInfo.Name + "\n" +
                            "Player:" + cHTSessionInfo.PlayerCount + "/" + cHTSessionInfo.MaxPlayers + "\n" + master;

        }

        public void OnCheckButtonClick()
        {
            checkButton.interactable = false;
            // CHTLandProxy.missionManager.SetMissionDone("241", "53");
        }

        void Start()
        {
            StartCoroutine(DelayGetRoomInfoAndRegisterCallback());
        }

        // Update is called once per frame
        void Update()
        {

        }
    }
}
