using System.Collections;
using System.Collections.Generic;
using CHTLand.SDK.Module;
using CHTLand.SDK.Module.Multiple;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

namespace TutorialMultiple
{
    public class ExampleGetRoomList : MonoBehaviour
    {
        [SerializeField]private TMP_Text[] txtRoomInfos;
        [SerializeField]private Button[] btnConnects;
        private List<CHTSessionInfo> roomList;
        private bool refreshRoomList = false;
        private float refreshCount  = 0;

        private IEnumerator DelayGetRoomInfo()
        {
            yield return new WaitForSeconds(5.0f);
            CHTLandProxy.multiConnectManager.StartSearchRoom(this);
            refreshRoomList =  true;
        }

        private void RefreshRoomList()
        {
             foreach(Button btn in btnConnects)
                btn.interactable = false;

            roomList = CHTLandProxy.multiConnectManager.GetRoomList();
            if(roomList != null)
            {
                for(int i = 0; i < roomList.Count; i++)
                {
                    txtRoomInfos[i].text = roomList[i].Name + ":" + roomList[i].PlayerCount + "/" + roomList[i].MaxPlayers;
                    btnConnects[i].interactable = true;
                }
            }
        }

        public void ClickConnectRoom(int index)
        {
            if(roomList != null && roomList.Count > index)
                CHTLandProxy.multiConnectManager.Connect(ConnectType.Specify, roomList[index].Name);
        }
        
        
        void Start()
        {
            StartCoroutine(DelayGetRoomInfo());
        }

        
        void Update()
        {
            if(refreshRoomList && refreshCount > 3)
            {
                refreshCount = 0;
                RefreshRoomList();
            }
            refreshCount += Time.deltaTime;
        }
    }
}
