using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using CHTLand.SDK.Module;
namespace TutorialPlayer
{
    public class ExamplePlayerJumpControl : MonoBehaviour
    {
        // 設定 Player 跳高高度
        float jump_height=0;
        
        private void OnTriggerEnter(Collider other)
        {
            Debug.Log("要跳比較高");
            jump_height = 10.0f;
            SetJumpHeight(jump_height);
            FinishLayer.isJumpOK = true;
        }

        private void OnTriggerExit(Collider other) { 
            jump_height = 2.5f;
             Debug.Log("恢復原本跳的高度");
             SetJumpHeight(jump_height);
        }
        private void SetJumpHeight(float jump_height)
        {
            CHTLandProxy.playerManager.GetLocalPlayer().SetJumpHeight(jump_height);
        }

        public void SetPlayerPosition(){
              Debug.Log("移動Avatar到指定物體位置!");
            CHTLandProxy.playerManager.GetLocalPlayer().SetAvatarPosition(this.transform.position);
        }
    }
}
