using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using CHTLand.SDK.Module;
using UnityEngine.UI;
using TMPro;
namespace TutorialPlayer
{
    public class ExamplePlayerSetHp : MonoBehaviour
    {
        // 設定 HP Value
        const int maxhp = 100;
        public bool is_add_hp = true;
        private int count_hp = 0;
        public TMP_Text text_hp;
        public Material m_gray;
        public Material m_original;
        private void OnTriggerEnter(Collider other)
        {
            if (is_add_hp)
            {
                Debug.Log("要加HP");
                count_hp = 10;
            }
            else
            {
                Debug.Log("要減HP");
                count_hp = -10;
            }
            int now_hp = CHTLandProxy.playerManager.GetLocalPlayer().GetHP();
            int result = now_hp + count_hp;
            SetHP(result);
            FinishLayer.isHPOK = true;

        }

        public void ControlHP(int cal_hp)
        {
            int now_hp = CHTLandProxy.playerManager.GetLocalPlayer().GetHP();
            int result = now_hp + cal_hp;
            SetHP(result);
            FinishLayer.isHPOK = true;
        }
        private void SetHP(int HP)
        {
            if (HP > maxhp) { HP = maxhp; }
            if (HP < 0) { HP = 0; }
            CHTLandProxy.playerManager.GetLocalPlayer().SetHP(HP);
            text_hp.text = "Your HP Value is " + HP + " .";
            this.GetComponent<MeshRenderer>().material = m_gray;
            Invoke("ChangeOrigin",0.3f);
        }

        private void ChangeOrigin(){
           this.GetComponent<MeshRenderer>().material = m_original;
        }


    }


}
