using UnityEngine;
using CHTLand.SDK.Module;
using TMPro;
using System;
using UnityEngine.UI;

public class MicToByteArray : MonoBehaviour
{
    private bool isRecording = false;
    public TMP_Text statusText;

    void Start()
    {

    }

    public void RequestPermission()
    {
        CHTLandProxy.micManager.RequestPermission();
        CHTLandProxy.networkRequestManager.WebSocketConnect("ws://localhost:8766",
                                                            () => { Debug.Log("Connection open!"); },
                                                            (bytes) => { statusText.text += "OnMessage! " + System.Text.Encoding.UTF8.GetString(bytes) + "\n"; },
                                                            (error) => { Debug.Log("OnError! " + error); },
                                                            () => { Debug.Log("Connection closed!"); }
        );
    }

    public void Recording()
    {
        if (!isRecording)
        {
            CHTLandProxy.multiConnectManager.ChangeVoiceType(CHTLand.SDK.Module.Multiple.VoiceType.Release);
            StartRecording();
            isRecording = true;
        }
    }
    public void StopRecord()
    {
        if (isRecording)
        {
            StopAndProcessAudio();
            CHTLandProxy.multiConnectManager.ChangeVoiceType(CHTLand.SDK.Module.Multiple.VoiceType.TotalArea);
            isRecording = false;
        }
    }
    AudioClip clip;
    /// <summary>
    /// 開始錄音
    /// </summary>
    public void StartRecording()
    {
        CHTLandProxy.networkRequestManager.WebSocketSendText("Start Recording");
        clip = CHTLandProxy.micManager.StartLocalMic();
    }

    /// <summary>
    /// 停止錄音並處理音訊數據
    /// </summary>
    public void StopAndProcessAudio()
    {
        CHTLandProxy.networkRequestManager.WebSocketSendText("Stop Recording");
        CHTLandProxy.micManager.EndLocalMic();
        Debug.Log("Clip Length: " + clip.length);
        if (clip != null && clip.length > 0)
        {
            float[] audioData = new float[clip.samples * clip.channels];
            clip.GetData(audioData, 0);
            byte[] byteArray = FloatArrayToByteArray(audioData);
            // 在這裡可以使用 byteArray，例如發送到伺服器或保存到文件
            int chunkSize = 4096; // 每次傳輸 4KB 的資料
            for (int i = 0; i < byteArray.Length; i += chunkSize)
            {
                int currentChunkSize = Mathf.Min(chunkSize, byteArray.Length - i);
                byte[] chunk = new byte[currentChunkSize];
                System.Array.Copy(byteArray, i, chunk, 0, currentChunkSize);
                CHTLandProxy.networkRequestManager.WebSocketSend(chunk);
            }
            Debug.Log("Audio data converted to byte array and sent. Length: " + byteArray.Length);
            statusText.text += "Audio data converted to byte array and sent. Length: " + byteArray.Length + "\n";
        }
        else
        {
            Debug.LogWarning("No audio data captured.");
        }
    }

    /// <summary>
    /// 將 float[] 音訊數據轉換為 byte[]
    /// </summary>
    /// <param name="floatArray">音訊數據</param>
    /// <returns>Byte 陣列</returns>
// 透過 Buffer.BlockCopy 實現的版本 (可能更高效)
    public byte[] FloatArrayToByteArray(float[] floatArray)
    {
        // C# 的 float 是 4 個 byte
        // short 是 2 個 byte
        byte[] byteArray = new byte[floatArray.Length * sizeof(short)];

        // 直接將 float[] 的內容複製到 byte[]，但這會是 32-bit 的 PCM
        Buffer.BlockCopy(floatArray, 0, byteArray, 0, byteArray.Length);

        // 或者，如果你堅持 16-bit 轉換，可以用以下方式
        byte[] result = new byte[floatArray.Length * 2];
        for (int i = 0; i < floatArray.Length; i++)
        {
            short sample = (short)(floatArray[i] * short.MaxValue);
            // 如果需要大端序，可以調整位元順序
            result[i * 2] = (byte)(sample & 0xFF);
            result[i * 2 + 1] = (byte)((sample >> 8) & 0xFF);
        }
        return result;
    }
}