﻿using System;
using UniJSON;

namespace UniGLTF
{
    [Serializable]
    public class glTFAssets
    {
        public string generator;

        [JsonSchema(Required = true, Pattern = "^[0-9]+\\.[0-9]+$")]
        public string version;

        public string copyright;

        [JsonSchema(Pattern = "^[0-9]+\\.[0-9]+$")]
        public string minVersion;

        // empty schemas
        public glTFExtension extensions;
        public glTFExtension extras;

        public override string ToString()
        {
            return string.Format("GLTF-{0} generated by {1}", version, generator);
        }
    }
}
